+++
title = "GISAS"
weight = 40
+++

### GISAS by rough interfaces

{{< figscg src="/img/draw/CorrelatedRoughness_setup.jpg" width="350px">}}

Scattering from a multilayered sample with correlated roughness.

* The sample is composed of a substrate on which is sitting a stack of layers.
These layers consist in a repetition of 5 times two different superimposed layers (from bottom to top):
  * layer A: $2.5$ nm thick with a real refractive index $n = 5 \cdot 10^{-6}$.
  * layer B: $5$ nm thick with a real refractive index $n = 10 \cdot 10^{-6}$.
* There is no added particle.
* All layers present the same type of roughness on the top surface, which is characterized by:
  * a rms roughness of the interfaces $\sigma = 1$ nm,
  * a Hurst parameter $H$ equal to $0.3$,
  * a lateral correlation length $\xi$ of $5$ nm,
  * a common cross correlation length $\xi\_{\perp}$ equal to $10$ nm,
  * a height distribution is normal.
* The incident beam is characterized by a wavelength of 0.1 nm.
* The incident angles are $\alpha\_i = 0.2 ^{\circ}$ and $\varphi\_i = 0^{\circ}$.

So the model with [SelfAffineFractalModel](/ref/sample/roughness/interface), [ErfTransient](/ref/sample/roughness/transient),
[CommonDepthCrosscorrelation](/ref/sample/roughness/xcorr) is used here.

{{<figscg src="/img/auto/scatter2d/CorrelatedRoughness.png" width="350px">}}

{{< show-ex file="scatter2d/CorrelatedRoughness.py" >}}
